/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.tileentities.SlottedChestTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class SlottedChest
extends BaseEntityBlock
implements IReadable {
    protected SlottedChest() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
        String name = "slotted_chest";
        this.setRegistryName(name);
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SlottedChestTileEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (te instanceof SlottedChestTileEntity) {
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((SlottedChestTileEntity)te).iInv);
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        BlockEntity te;
        if (!worldIn.f_46443_ && (te = worldIn.m_7702_(pos)) instanceof SlottedChestTileEntity) {
            ItemStack[] filter = ((SlottedChestTileEntity)te).lockedInv;
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)((SlottedChestTileEntity)te), buf -> {
                for (ItemStack lock : filter) {
                    buf.m_130055_(lock);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)new TranslatableComponent("tt.essentials.slotted_chest.desc"));
        tooltip.add((Component)new TranslatableComponent("tt.essentials.slotted_chest.quip").m_6270_(ESConfig.TT_QUIP));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof SlottedChestTileEntity) {
            float val = ((SlottedChestTileEntity)te).calcComparator() * 15.0f;
            val = Mth.m_14143_((float)(val * 14.0f)) + (val > 0.0f ? 1 : 0);
            return (int)val;
        }
        return 0;
    }

    @Override
    public float read(Level world, BlockPos pos, BlockState state) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof SlottedChestTileEntity) {
            return ((SlottedChestTileEntity)te).calcComparator() * 15.0f;
        }
        return 0.0f;
    }
}

